# /www/admin/sdb/object-view.tcl
ad_page_contract {
    Shows the definition for a table, view, sequence, trigger, or
    PL/SQL object in a database.

    @author eveander@eveander.com
    @creation-date 18 octubre 2002
    @cvs-id $Id: object-view.tcl,v 1.2 2002/10/25 18:17:53 eve Exp $
} {
    object_name
    object_type
    object_subtype
    {show_constraints_p "0"}
}

set object_type_pretty(table) Table
set object_type_pretty(view) View
set object_type_pretty(sequence) Sequence
set object_type_pretty(trigger) Trigger
set object_type_pretty(plsql) "PL/SQL Object"

set title "$object_name[util_decode $object_subtype "" "" " ([string tolower $object_subtype])"]"


ReturnHeaders

ns_write "[ad_admin_header $title]
<h2>$title</h2>

[ad_admin_context_bar [list "/admin/sdb/?[export_url_vars object_type]" "Schema and Data Browser"] "One $object_type_pretty($object_type)"]

<hr>
"


if {$object_type == "table" } {

    # see if there are any table-level comments
    set table_comments ""
    db_foreach get_table_level_comments "select comments from user_tab_comments where table_name = :object_name and comments is not null" {
	append table_comments "$comments<p>"
    }

    ns_write "$table_comments
    <table border=1>
    <tr><th>column_name</th><th>data_type</th><th>data_length</th><th>data_scale</th><th>data_precision</th><th>nullable</th><th>data_default</th><th>comments</th>[util_decode $show_constraints_p 1 "<th>constraints</th>" ""]</tr>
    "

    db_foreach get_all_columns "select column_name, data_type, data_length, data_scale, data_precision, nullable from user_tab_columns where table_name = :object_name" {

        # get data_default, which is a long (so our Oracle driver can't select it directly)
	set data_default [db_exec_plsql get_data_default "begin :1 := sdb_get_col_data_default(:object_name,:column_name); end;"]

	# see if there are any row-level comments
	set row_comments ""
	db_foreach get_row_level_comments "select comments from user_col_comments where table_name = :object_name and column_name = :column_name and comments is not null" {
	    append row_comments "$comments<p>"
	}

        # get constraints
	if { $show_constraints_p } {
            set constraint_list [list]
	    db_foreach get_constraints "select ucc.constraint_name, uc.constraint_type, uc.r_constraint_name
            from user_cons_columns ucc, user_constraints uc
            where ucc.constraint_name = uc.constraint_name
            and ucc.table_name = :object_name
            and ucc.column_name = :column_name" {

                # constraint_type can be:
                # C: check
                # R: references
                # P: primary key
                # U: unique

                if { $constraint_type == "C" } {
                    set search_condition [db_exec_plsql get_search_condition "begin :1 := sdb_get_con_search_condition(:constraint_name); end;"]
                    lappend constraint_list "$constraint_name: check $search_condition"
		} elseif { $constraint_type == "R" } {
		    set r_table_name [db_string get_table_referenced "select table_name from user_constraints where constraint_name = :r_constraint_name"]
                    lappend constraint_list "$constraint_name: references $r_table_name"
		} elseif { $constraint_type == "P" } {
                    lappend constraint_list "$constraint_name: primary key"
		} elseif { $constraint_type == "U" } {
                    lappend constraint_list "$constraint_name: unique"
		} else {
                    lappend constraint_list "$constraint_name: unknown constraint of type $constraint_type"
		}


	    }

            set constraints [join $constraint_list "<br>"]
	}

	ns_write "<tr><td>$column_name</td><td>$data_type</td><td>$data_length</td><td>[ec_nbsp_if_null $data_scale]</td><td>[ec_nbsp_if_null $data_precision]</td><td>$nullable</td><td>[ec_nbsp_if_null $data_default]</td><td>[ec_nbsp_if_null $row_comments]</td>"

	if { $show_constraints_p } {
            ns_write "<td>[ec_nbsp_if_null $constraints]</td>"
	}

        ns_write "</tr>"

    }

    ns_write "</table>
    <p>
    <h3>Indices</h3>
    <ul>
    "

    set old_index_name ""
    set column_list [list]
    db_foreach get_all_indices "select index_name, column_name from user_ind_columns where table_name=:object_name order by index_name" {
	if { $old_index_name != $index_name && ![empty_string_p $old_index_name] } {
            ns_write "<li>$old_index_name on [join $column_list ", "]"
            set column_list [list]
	}
        lappend column_list $column_name
        set old_index_name $index_name
    }
    # write out last index
    if { ![empty_string_p $old_index_name] } {
        ns_write "<li>$old_index_name on [join $column_list ", "]"
    } else {
        ns_write "\[none\]"
    }


    ns_write "</ul>
    <p>
    <h3>Actions</h3>
    <ul>
    [util_decode $show_constraints_p 0 "<li><a href=object-view?[export_url_vars object_name object_type object_subtype]&show_constraints_p=1>View constraints</a>" ""]
    <li><a href=table-data?[export_url_vars object_name object_type object_subtype show_constraints_p]>View table data</a>
    </ul>
    "
    
    # done with object type table
} elseif { $object_type == "view" } {

    # get text, which is a long
    set text [db_exec_plsql get_text "begin :1 := sdb_get_view_text(:object_name); end;"]

    ns_write "<pre>$text</pre>"

    # done with object type view
} elseif { $object_type == "sequence" } {
    db_1row get_sequence_info "select min_value, max_value, increment_by, cycle_flag, order_flag, cache_size
    from user_sequences
    where sequence_name = :object_name"

    set sequence_def "create sequence $object_name"

    if { $increment_by > 0 } {
	if { $increment_by != 1 } {
            append sequence_def "\nincrement by $increment_by"
	}
	if { [string compare $min_value "1"] != 0 } {
            append sequence_def "\nminvalue $min_value"
	}
	if { [string compare $max_value "999999999999999999999999999"] != 0 } {
            append sequence_def "\nmaxvalue $max_value"
	}
	
    } else {
        append sequence_def "\nincrement by $increment_by"
	
	if { [string compare $min_value "-99999999999999999999999999"] != 0 } {
            append sequence_def "\nminvalue $min_value"
	}
	if { [string compare $max_value "-1"] != 0 } {
            append sequence_def "\nmaxvalue $max_value"
	}
    }
    
    if { $cycle_flag == "Y" } {
        append sequence_def "\ncycle"
    }
    if { $order_flag == "Y" } {
        append sequence_def "\norder"
    }
    if { $cache_size != 20 } {
        append sequence_def "\ncache $cache_size"
    }
    
    ns_write "<pre>$sequence_def;</pre>"
    
    # done with object type sequence
} elseif { $object_type == "trigger" } {
    
    db_1row get_trigger_info "select trigger_type, triggering_event, table_name, when_clause, description
    from user_triggers
    where trigger_name = :object_name"

    # get trigger_body, which is a long
    set trigger_body [db_exec_plsql get_trigger_body "begin :1 := sdb_get_trigger_body(:object_name); end;"]

    ns_write "Trigger Type: $trigger_type<br>
    Triggering Event: $triggering_event<br>
    Table Name: $table_name<br>
    When Clause:<blockquote><pre>$when_clause</pre></blockquote>
    Description:<blockquote><pre>$description</pre></blockquote>
    Trigger Body:<blockquote><pre>$trigger_body</pre></blockquote>
    "


    # done with object type trigger
} else {
    # type plsql
    
    ns_write "<blockquote><pre>
    "
    
    db_foreach get_lines "select text from user_source where name=:object_name and type=:object_subtype order by line" {
        # text appears to always end with a newline, so we don't have to add one
        ns_write "$text"
}

    ns_write "</pre></blockquote>"


    # done with object type plsql
}


ns_write "[ad_admin_footer]
"
