# /www/admin/sdb/table-data.tcl
ad_page_contract {
    Shows the data in a table (referred to by object_name).
    By default shows up to 50 rows, unless show_all_data_p
    is 1.

    @author eveander@eveander.com
    @creation-date 18 octubre 2002
    @cvs-id $Id: table-data.tcl,v 1.1 2002/10/18 23:20:17 eve Exp $
} {
    object_name
    object_type
    object_subtype
    {show_constraints_p "0"}
    {show_all_data_p "0"}
    {order_by ""}
}

set n_rows_by_default 50
set n_rows_at_a_time 10

set title "Data in $object_name"

ReturnHeaders

ns_write "[ad_admin_header $title]
<h2>$title</h2>

[ad_admin_context_bar [list "/admin/sdb/?[export_url_vars object_type]" "Schema and Data Browser"] [list "object-view?[export_url_vars object_name object_type object_subtype show_constraints_p]" "One Table"] "Data"]

<hr>
"

set n_rows_in_table [db_string get_n_rows_in_table "select count(*) from [DoubleApos $object_name]"]

if { $n_rows_in_table <= $n_rows_by_default} {
    ns_write "Displaying all $n_rows_in_table rows:"
} elseif { $show_all_data_p == 0 } {
    ns_write "Displaying $n_rows_by_default rows (<a href=table-data?[export_url_vars object_name object_type object_subtype show_constraints_p]&show_all_data_p=1>show all $n_rows_in_table rows</a>):"
} else {
    ns_write "Displaying all $n_rows_in_table rows (<a href=table-data?[export_url_vars object_name object_type object_subtype show_constraints_p]&show_all_data_p=0>show only $n_rows_by_default</a>):"
}

# get columns
# this is a list of column names
set good_column_list [list]
# this is a list of column names and types
set unqueryable_column_list [list]

db_foreach get_all_columns "select column_name, data_type from user_tab_columns
 where table_name=:object_name" {
    if { $data_type == "BLOB" || $data_type == "CLOB" || $data_type == "LONG" || $data_type == "UNDEFINED" } {
        lappend unqueryable_column_list [list $column_name $data_type]
    } else {
        lappend good_column_list $column_name
    }
}

set sql_query "select [join $good_column_list ","] from [DoubleApos $object_name]"

if { ![empty_string_p $order_by] } {
    append sql_query " order by upper($order_by)"
}

set row_tally 0
set row_tally_total 0
db_foreach get_rows $sql_query {

    if { $row_tally == 0 } {
        ns_write "<p>
        <table border=1 cellspacing=0 cellpadding=2>
        <tr>
        "
        foreach column_name $good_column_list {
            ns_write "<th><a href=table-data?[export_url_vars object_name object_type object_subtype show_constraints_p show_all_data_p]&order_by=$column_name>$column_name</a></th>"
	}
        ns_write "</tr>"
    }

    ns_write "<tr>"
    foreach column_name $good_column_list {
        ns_write "<td valign=top>[ec_nbsp_if_null [set [string tolower $column_name]]]</td>"
    }
    ns_write "</tr>"

    incr row_tally
    incr row_tally_total

    if {$row_tally == $n_rows_at_a_time} {
        set row_tally 0
        ns_write "</table>
        "
    }

    if {!$show_all_data_p && $row_tally_total >= $n_rows_by_default} {
        break
    }

}


if { $row_tally != 0 } {

    ns_write "</table>"
}

foreach column_and_type $unqueryable_column_list {
    ns_write "<ul><li>Not showing [lindex $column_and_type 0] because the data type is [lindex $column_and_type 1]</ul>"
}

ns_write "[ad_admin_footer]"
