-- /www/doc/sql/sdb.sql
-- Schema and Data Browser
-- author: Eve Andersson (eveander@eveander.com)
-- $Id: sdb.sql,v 1.14 2002/10/18 23:16:12 eve Exp $

-- These 4 PL/SQL functions allow us to select LONG values from
-- Oracle's data dictionary.  Our Oracle driver doesn't support
-- LONGs.

create or replace function sdb_get_col_data_default (v_table_name IN user_tab_columns.table_name%TYPE, v_column_name IN user_tab_columns.column_name%TYPE) return varchar
IS
   v_4000char       VARCHAR(4000);
   v_data_default   user_tab_columns.data_default%TYPE;
BEGIN
   select data_default into v_data_default from user_tab_columns where table_name = v_table_name and column_name = v_column_name;
   v_4000char := SUBSTR (v_data_default, 1, 4000);
   return v_4000char;
END;
/
show errors

create or replace function sdb_get_con_search_condition (v_constraint_name IN user_constraints.constraint_name%TYPE) return varchar
IS
   v_4000char           VARCHAR(4000);
   v_search_condition   user_constraints.search_condition%TYPE;
BEGIN
   select search_condition into v_search_condition from user_constraints where constraint_name = v_constraint_name;
   v_4000char := SUBSTR (v_search_condition, 1, 4000);
   return v_4000char;
END;
/
show errors


create or replace function sdb_get_view_text (v_view_name IN user_views.view_name%TYPE) return varchar
IS
   v_4000char      VARCHAR(4000);
   v_text          user_views.text%TYPE;
BEGIN
   select text into v_text from user_views where view_name = v_view_name;
   v_4000char := SUBSTR (v_text, 1, 4000);
   return v_4000char;
END;
/
show errors


create or replace function sdb_get_trigger_body (v_trigger_name IN user_triggers.trigger_name%TYPE) return varchar
IS
   v_4000char      VARCHAR(4000);
   v_trigger_body  user_triggers.trigger_body%TYPE;
BEGIN
   select trigger_body into v_trigger_body from user_triggers where trigger_name = v_trigger_name;
   v_4000char := SUBSTR (v_trigger_body, 1, 4000);
   return v_4000char;
END;
/
show errors
