# /www/admin/sdb/index.tcl
ad_page_contract {
    Shows all the tables, views, sequences, triggers, and PL/SQL
    objects in a database.

    You can optionally specify object_type as one of the following:
    table, view, sequence, trigger, plsql

    @author Eve Andersson (eveander@eveander.com)
    @creation-date 17 octubre 2002
    @cvs-id $Id: index.tcl,v 1.3 2002/10/25 18:17:43 eve Exp $
} {
    {object_type "table"}
}

set object_type_list [list table view sequence trigger plsql]

set object_type_pretty(table) Table
set object_type_pretty(view) View
set object_type_pretty(sequence) Sequence
set object_type_pretty(trigger) Trigger
set object_type_pretty(plsql) "PL/SQL Object"

set title "Schema and Data Browser: All $object_type_pretty($object_type)s"

ReturnHeaders

ns_write "[ad_admin_header $title]
<h2>$title</h2>

[ad_admin_context_bar "Schema and Data Browser"]

<hr>
<b>Display:</b>
"

set first_iteration_p 1
foreach object_type_available $object_type_list {
    if { !$first_iteration_p } {
        ns_write " | "
    } else {
        set first_iteration_p 0
    }
    if { $object_type == $object_type_available } {
        ns_write "$object_type_pretty($object_type_available)s"
    } else {
        ns_write "<a href=index?object_type=$object_type_available>$object_type_pretty($object_type_available)s</a>"
    }
}

# query for object names and subtypes; for tables, views, sequences, and triggers,
# there are no subtypes, but pl/sql objects can have subtype
# FUNCTION, PROCEDURE, PACKAGE or PACKAGE BODY
if { $object_type == "table" } {
    set object_name_and_subtype_query "select table_name as object_name, '' as object_subtype from user_tables order by table_name"
    set count_query "select count(*) from user_tables"
} elseif { $object_type == "view" } {
    set object_name_and_subtype_query "select view_name as object_name, '' as object_subtype from user_views order by view_name"
    set count_query "select count(*) from user_views"
} elseif { $object_type == "sequence" } {
    set object_name_and_subtype_query "select sequence_name as object_name, '' as object_subtype
from user_sequences order by sequence_name"
    set count_query "select count(*) from user_sequences"
} elseif { $object_type == "trigger" } {
    set object_name_and_subtype_query "select trigger_name as object_name, '' as object_subtype from user_triggers order by trigger_name"
    set count_query "select count(*) from user_triggers order by trigger_name"
} else {
    set object_name_and_subtype_query "select name as object_name, type as object_subtype from user_source group by name, type order by name"
    set count_query "select count(*) from (select name, type from user_source group by name, type)"
}


# for formatting
set n_objects [db_string get_n_objects $count_query]
set half_n_objects [expr floor($n_objects/2)]


ns_write "<p>

$n_objects $object_type_pretty($object_type)s:

<p>

<table border=0 cellspacing=0 cellpadding=10>
<tr>
<td valign=top>
"

set object_count 0
db_foreach get_all_objects $object_name_and_subtype_query {
    incr object_count
    ns_write "<a href=object-view?[export_url_vars object_name object_type object_subtype]>$object_name</a>[util_decode $object_subtype "" "" " ([string tolower $object_subtype])"]<br>"
    if {$object_count == $half_n_objects && $object_type != "plsql"} {
        ns_write "</td><td valign=top>"
    }
}

ns_write "</tr></table>

<p>


Show <a href=objects-all>report of all database objects and their definitions</a> (can take many minutes or hours to run, depending on the size of your database and strength of your machine)

[ad_admin_footer]
"

